/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.UserCreatedPDUEvent;
import com.cisco.pt.ipc.events.UserCreatedPDUEventListener;
import com.cisco.pt.ipc.ui.UserCreatedPDU;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserCreatedPDUEventRegistry
extends IPCEventRegistry {
    protected Set<UserCreatedPDUEventListener> globalListeners = new HashSet<UserCreatedPDUEventListener>();
    protected Map<String, Set<UserCreatedPDUEventListener>> specificObjectListeners = new HashMap<String, Set<UserCreatedPDUEventListener>>();
    private static Log logger = LogFactory.getLog(UserCreatedPDUEventRegistry.class);

    public UserCreatedPDUEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "UserCreatedPDU";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        UserCreatedPDUEvent evt = null;
        if (eventName.equalsIgnoreCase("simplePduAdded")) {
            evt = new UserCreatedPDUEvent.SimplePduAdded(event);
        } else if (eventName.equalsIgnoreCase("complexPduAdded")) {
            evt = new UserCreatedPDUEvent.ComplexPduAdded(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (UserCreatedPDUEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<UserCreatedPDUEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (UserCreatedPDUEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(UserCreatedPDUEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("simplePduAdded");
                this.register("complexPduAdded");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(UserCreatedPDUEventListener listener, UserCreatedPDU objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<UserCreatedPDUEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<UserCreatedPDUEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "simplePduAdded");
                this.register(uuid, "complexPduAdded");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(UserCreatedPDUEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("simplePduAdded");
                this.deregister("complexPduAdded");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(UserCreatedPDUEventListener listener, UserCreatedPDU objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<UserCreatedPDUEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "simplePduAdded");
            this.deregister(uuid, "complexPduAdded");
            specificListeners.remove(listener);
        }
    }

    public void addListener(UserCreatedPDUEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(UserCreatedPDUEventListener listener, UserCreatedPDU objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(UserCreatedPDUEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(UserCreatedPDUEventListener listener, UserCreatedPDU objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

